function [last_episodes, av_all_episodes]=simulation_rep(alpha1,beta1,alpha2,beta2,T,vh,vl,mu_l,sigma_l,grid_middle,tick,grid_size,K)

%This function returns:

%last_episodes: A K x 6 matrix containing for each experiment k, the values in the last episode T
%of A_1, A_2, v_tilde, l, total profit of AMM1, total profit of AMM2.

%The inputs allow for any pair (alpha,beta) chosen by each market-maker.
%Note the code is restricted to using two market-makers only.

%Initialize
last_episodes = zeros(K,6);
av_all_episodes = zeros(T,8);

%Run K experiments.
%Replace "parfor" with "for" to run without parallelization.

parfor k=1:K
    %Calls the function simulation_exp
    [last_episode] = simulation_exp(alpha1,beta1,alpha2,beta2,T,vh,vl,mu_l,sigma_l,grid_middle,tick,grid_size);
    %Records the last episode
    last_episodes(k,:) = last_episode;

    %Uncomment the next line to follow the execution of the code
    %disp(k)
end
